﻿<%@ Control Language="C#" AutoEventWireup="true" CodeFile="ucPlan.ascx.cs" Inherits="ucPlan" %>

<script type="text/javascript">
  
    
    function AriaPlanAddSearchButton(el) {
        el.set({
            "role": 'button'
        });
    }

    function AriaPlanSaveButton(el) {
        el.set({
            "role": 'button'
        });
    }

    function AriaPlanAddinstrButton(el) {
        el.set({
            "role": 'button'
        });
    }

    function AriaPlanDelInstrButton(el) {
        el.set({
            "role": 'button'
        });
    }

    var ucPlanJS = {
        original: {
            planHash: ''
        },

        successSave: function () {
            var _me = this;

            _me.original.planHash = _me.takeSnapshot();

            App.direct.UCPLAN.ReloadPWEventNodes();
        },

        takeSnapshot: function () {
            var hash = '',
                i = 0,
                n = 0;

            hash = App.tfPLAN.getValue();
            hash += App.tfPLNEventTitle.getValue();
            hash += App.dfPLNEventDate.getValue();

            n = App.gpPLNSelInstruments.getStore().data.items.length;
            for (i = 0; i < n; i++) {
                
                //does not work in 3.1!
                //hash += App.gpPLNSelInstruments.getStore().data.items[i].raw.MID;
                hash += App.gpPLNSelInstruments.getStore().data.items[i].data.MID;
            }

            return hash;
        },

        valPlan: function () {
            if (App.tfPLAN.isValid() && App.tfPLNEventTitle.isValid() && App.dfPLNEventDate.isValid()) {
                App.btnUCPlanSave.setDisabled(false);
            }
            else {
                App.btnUCPlanSave.setDisabled(true);
            }
        },

        valSearch: function () {
            if (App.tfPLANEITSearch.isValid()) {
                App.btnPlanSearch.setDisabled(false);
                App.btnPLANInsSelOK.setDisabled(false);
            }
            else {
                App.btnPlanSearch.setDisabled(true);
                App.btnPLANInsSelOK.setDisabled(true);
            }
        },

        // INITIALIZING FUNCTIONS
        init: function () {
            var _me = this,
                i = 0,
                n = 0;

            //wait for DOM readiness
            $(document).ready(function () {
                Ext.onReady(function () {
                    setTimeout(function () {
                        //cal functions here

                        _me.original.planHash = _me.takeSnapshot();

                    }, 1);
                });
            });
        }

    };

    ucPlanJS.init();

</script>

<ext:Window ID="wndPLANAddInstrument" Title="Add Instrument(s)" Hidden="true"
    Layout="AnchorLayout" Height="515" Width="720" 
     IDMode="Static" runat="server" 
    Constrain="true"
    ConstrainToElement="pnlMainWorkspace"
    
    Modal="true"
    Collapsible="false"
    Resizable="false"
    Maximizable="false"
    Draggable="false" 
    XOnEsc="Ext.emptyFn">
    <Listeners>
        <BeforeShow Handler="App.pnlMMenu.mask();App.vpMasterViewport.mask();"></BeforeShow>
        <Hide Handler="App.tfPLANEITSearch.setValue('');App.pnlMMenu.unmask();App.vpMasterViewport.unmask();" />
        <Close Handler="App.tfPLANEITSearch.setValue('');App.pnlMMenu.unmask();App.vpMasterViewport.unmask();" />
    </Listeners>
    <Items>
        <ext:FormPanel
            runat="server"
            Border="false"
            Layout="VBoxLayout"
            AnchorHorizontal="100%"
            AnchorVertical="100%">
            <LayoutConfig>
                <ext:VBoxLayoutConfig Align="Stretch" />
            </LayoutConfig>
            <Items>

                <ext:Panel Border="false" 
                    Layout="ColumnLayout" 
                    Margin="3"
                    runat="server" Width="720">
                    <Items>
                        <ext:Panel
                            runat="server"
                            Border="true"
                            BodyStyle="border: 1px solid lightgray;"
                            Margin="2"
                            Layout="ColumnLayout" Width="700">
                            <Items>
                                <ext:RadioGroup
                                    ID="rgPLANInstrumentType"
                                    runat="server"
                                    Vertical="true" FieldLabel="Filter by"
                                    Width="350"
                                    LabelWidth="50"
                                    Margin="5">
                                    <Items>
                                        <ext:Radio MarginSpec="0 0 0 5"  
                                            ID="rdoPLANEITCPA"
                                            Width="160"
                                            BoxLabel="Clinical Program Area"
                                            runat="server">
                                        </ext:Radio>
                                        <ext:Radio MarginSpec="0 0 0 5"  
                                            ID="rdoPLANEITDisp"
                                            Width="85"
                                            BoxLabel="Disciplines"
                                            runat="server">
                                        </ext:Radio>
                                        <ext:Radio MarginSpec="0 0 0 5"  
                                            ID="rdoPLANEITAll"
                                            Width="80"
                                            BoxLabel="All"
                                            Checked="true"
                                            runat="server">
                                        </ext:Radio>
                                    </Items>
                                    <Listeners>
                                        <Change Handler="App.direct.UCPLAN.OnGroupTypeSelect();" />
                                    </Listeners>
                                </ext:RadioGroup>
                                <ext:TextField ID="tfPLANEITSearch" Width="250" LabelWidth="45" runat="server" Margin="5" FieldLabel="Search" Vtype="alphanumXSS">
                                    <Listeners>
                                        <Change Fn="ucPlanJS.valSearch" />
                                    </Listeners>
                                </ext:TextField>
                                <ext:Button ID="btnPlanSearch" Text="Search" Handler="App.direct.UCPLAN.OnSearch();" runat="server" Icon="Magnifier" Margin="2" Padding="5">
                                    <Listeners>
                                           <AfterRender Handler="AriaPlanAddSearchButton(App.btnPlanSearch.getEl());" ></AfterRender>
                    
                                    </Listeners>
                                </ext:Button>
                            </Items>
                        </ext:Panel>
                    </Items>
                </ext:Panel>

                <ext:ComboBox
                    ID="cboPLANInstrumentGroup"
                    runat="server"
                    Editable="false"
                    ValueField="MODULE_GROUP_ID"
                    DisplayField="MODULE_GROUP_DESCR"
                    AnchorHorizontal="99%"
                    FieldLabel="Choose Filter"
                    LabelWidth="80"
                    Padding="3">
                    <Store>
                        <ext:Store ID="storPLANModuleGroups" AutoLoad="true" runat="server">
                            <Model>
                                <ext:Model ID="mdlPLANGroupTypes" runat="Server" IDProperty="MODULE_GROUP_ID">
                                    <Fields>
                                        <ext:ModelField Name="MODULE_GROUP_ID" />
                                        <ext:ModelField Name="MODULE_GROUP_DESCR" />
                                    </Fields>
                                </ext:Model>
                            </Model>
                            <Reader>
                                <ext:JsonReader RootProperty="Tables[0].Rows">
                                </ext:JsonReader>
                            </Reader>
                        </ext:Store>
                    </Store>
                    <Listeners>
                        <Select Handler="App.direct.UCPLAN.OnGroupSelect();" />
                    </Listeners>
                </ext:ComboBox>
                <ext:GridPanel
                    ID="gpPLANInstruments"
                    runat="server"
                    Layout="FitLayout"
                    Padding="0"
                    Border="false"
                    Title="Filtered Instruments"
                    Flex="1" Width="710"
                    OverflowY="Scroll">
                    <Listeners>
                    </Listeners>
                    <SelectionModel>
                        <ext:CheckboxSelectionModel ID="smPLANInstruments" runat="server" Mode="Simple">
                            <Listeners>
                            </Listeners>
                        </ext:CheckboxSelectionModel>
                    </SelectionModel>
                    <ColumnModel runat="server">
                        <Columns>
                            <ext:Column runat="server"
                                DataIndex="MODULE" Text="Instrument Name"
                                Flex="48">
                                <Renderer Handler="return Ext.util.Format.htmlDecode(value);" />
                            </ext:Column>
                            <ext:Column runat="server"
                                DataIndex="DESCRIPTION" Text="Description"
                                Flex="48">
                                <Renderer Handler="return Ext.util.Format.htmlDecode(value);" />
                            </ext:Column>
                        </Columns>
                    </ColumnModel>
                    <Store>
                        <ext:Store
                            ID="storPLANInstruments"
                            AutoLoad="true"
                            runat="server">
                            <Model>
                                <ext:Model ID="mdlPLANInstruments" runat="Server" IDProperty="MID">
                                    <Fields>
                                        <ext:ModelField Name="MID" />
                                        <ext:ModelField Name="MODULE">
                                        </ext:ModelField>
                                        <ext:ModelField Name="MODULE_FOR" />
                                        <ext:ModelField Name="DESCRIPTION">
                                        </ext:ModelField>
                                    </Fields>
                                </ext:Model>
                            </Model>
                            <Reader>
                                <ext:JsonReader RootProperty="Tables[0].Rows">
                                </ext:JsonReader>
                            </Reader>
                        </ext:Store>
                    </Store>
                </ext:GridPanel>
            </Items>
        </ext:FormPanel>
    </Items>
    <BottomBar>
        <ext:Toolbar ID="tbPLANInstrumentSelection" runat="server">
            <Items><ext:Button ID="btnPLANInsSelOK" runat="server" Text="OK" Icon="Disk" Disabled="false">
                    <DirectEvents>
                        <Click OnEvent="OnInstrSelOK" 
                            Before="App.btnPLANInsSelOK.setDisabled(true)"
                            Success="App.btnPLANInsSelOK.setDisabled(false);App.direct.UCPLAN.ReloadPWEventNodes()">
                            <ExtraParams>
                                <ext:Parameter Name="gpSelParam" Value="Ext.util.Format.htmlEncode( Ext.encode(#{gpPLANInstruments}.getRowsValues({selectedOnly : true})) )" Mode="Raw" />
                            </ExtraParams>
                        </Click>
                    </DirectEvents>
                </ext:Button>
                <ext:Button ID="btnPLANInsSelCancel" runat="server" Text="Cancel" Icon="Cancel" Handler="App.wndPLANAddInstrument.hide();" />
            </Items>
        </ext:Toolbar>
    </BottomBar>
</ext:Window>

<ext:Panel Margin="0"
    Border="false"
    runat="server"
    Visible="true"
    Layout="VBoxLayout"
    AutoScroll="true"
    AnchorVertical="100%"
    AnchorHorizontal="100%">
    <TopBar>
        <ext:Toolbar runat="server">
            <Items>
                <ext:Button ID="btnUCPlanSave" runat="server" Text="Save Plan" Icon="Disk">
                    <Listeners>
                        <AfterRender Handler="AriaPlanSaveButton(App.btnUCPlanSave.getEl());" />
                    </Listeners>
                    <DirectEvents>
                        <Click OnEvent="OnPlanOK" Success="ucPlanJS.successSave()">
                            <ExtraParams>
                                <ext:Parameter Name="gpSelPLNParam" Value="Ext.encode(  #{gpPLNSelInstruments}.getRowsValues({selectedOnly : false})  )" Mode="Raw" />
                            </ExtraParams>
                        </Click>
                    </DirectEvents>
                </ext:Button>
            </Items>
        </ext:Toolbar>
    </TopBar>
    <LayoutConfig>
        <ext:VBoxLayoutConfig Align="Stretch"></ext:VBoxLayoutConfig>
    </LayoutConfig>
    <Items>

       

                <ext:Label Padding="3" runat="server" Text="Assessment"></ext:Label>

                <ext:ComboBox runat="server"
                    ID="cboPLNTemplate" FieldLabel="Template"
                    Editable="false" LabelWidth="55" Width="100" Padding="3"
                    ValueField="TEMPLATE_ID"
                    DisplayField="DESCRIPTION">
                    <Store>
                        <ext:Store ID="storePLNTemplates" AutoLoad="true" runat="server">
                            <Model>
                                <ext:Model runat="server" IDProperty="TEMPLATE_ID">
                                    <Fields>
                                        <ext:ModelField Name="TEMPLATE_ID" />
                                        <ext:ModelField Name="DESCRIPTION" />
                                    </Fields>
                                </ext:Model>
                            </Model>
                            <Reader>
                                <ext:JsonReader RootProperty="Tables[0].Rows">
                                </ext:JsonReader>
                            </Reader>
                        </ext:Store>
                    </Store>
                    <Listeners>
                        <Change Handler="App.direct.UCPLAN.LoadPlanTemplate(this.getValue());" />
                    </Listeners>
                </ext:ComboBox>

                <ext:TextArea Padding="3" runat="server" ID="tfPLAN" Height="100" Vtype="alphanumXSS">
                    <Listeners>
                        <Change Fn="ucPlanJS.valPlan" />
                    </Listeners>
                </ext:TextArea>

                <ext:Label Padding="3" runat="server" Text="Plan"></ext:Label>

                <ext:Panel Width="300" Border="false" Layout="ColumnLayout" runat="server" Anchor="100%">
                    <Items>

                        <ext:TextField FieldLabel="Title" LabelWidth="55" AutoDataBind="true"
                            Padding="3" ID="tfPLNEventTitle" ReadOnly="false" Width="300" runat="server"
                            Vtype="alphanumSpace">
                            <Listeners>
                                <Change Fn="ucPlanJS.valPlan" />
                            </Listeners>
                        </ext:TextField>

                        <ext:DateField ID="dfPLNEventDate"
                            runat="server"
                            AllowBlank="true"
                            FieldLabel="Date" LabelWidth="40"
                            AutoDataBind="true"
                            Width="180"
                            Padding="3"
                            Format="MM/dd/yyyy"
                            Vtype="date"
                            InvalidText="{0} is not a valid date - it must be in the format MM/DD/YYYY">
                            <Listeners>
                                <Change Fn="ucPlanJS.valPlan" />
                            </Listeners>
                        </ext:DateField>

                        <ext:Checkbox ID="chkPLNAdjustFuture" Padding="3"
                            runat="server"
                            BoxLabel="Adjust Future Dates?"
                            HideEmptyLabel="true">
                        </ext:Checkbox>
                    </Items>
                </ext:Panel>
            

        <ext:GridPanel
            ID="gpPLNSelInstruments"
            runat="server" 
            Region="Center" 
            Border="false" IDMode="Static"
            Layout="FitLayout" 
            AnchorVertical="100%"
            AnchorHorizontal="100%"  
            Flex="1"
            Title="Selected Instruments">
            <SelectionModel>
                <ext:RowSelectionModel ID="smPLNSelInstruments" runat="server" Mode="Single" />
            </SelectionModel>
            <ColumnModel ID="cmdlPLNSelInstruments" runat="server">
                <Columns>
                    <ext:Column runat="server"
                        DataIndex="MODULE" Text="Instrument Name"
                        Flex="45">
                        <Renderer Handler="return Ext.util.Format.htmlDecode(value);" />
                    </ext:Column>

                    <ext:ComponentColumn ID="ucPLNselModuleFor"
                        runat="server"
                        Editor="true"
                        DataIndex="MODULE_FOR"
                        Flex="0"
                        Text="For" Visible="false">
                        <Component>
                            <ext:ComboBox runat="server" Editable="false">
                                <Items>
                                    <ext:ListItem Text="Patient" Value="1" Mode="Raw" />
                                    <ext:ListItem Text="Provider" Value="2" Mode="Raw" />
                                    <ext:ListItem Text="Both" Value="3" Mode="Raw" />
                                </Items>
                            </ext:ComboBox>
                        </Component>
                    </ext:ComponentColumn>
                </Columns>
            </ColumnModel>
            <Store>
                <ext:Store
                    ID="storPLNSelInstruments"
                    AutoLoad="true"
                    runat="server">
                    <Model>
                        <ext:Model ID="mdlPLNSelInstruments" runat="Server" IDProperty="MID">
                            <Fields>
                                <ext:ModelField Name="MID" />

                                <ext:ModelField Name="MODULE">
                                    <Convert Handler="return Ext.util.Format.htmlDecode(value);" />
                                </ext:ModelField>

                                <ext:ModelField Name="MODULE_FOR" />
                                <ext:ModelField Name="MODULE_ALT_LANG" />
                            </Fields>
                        </ext:Model>
                    </Model>
                    <Reader>
                        <ext:JsonReader RootProperty="Tables[0].Rows">
                        </ext:JsonReader>
                    </Reader>
                </ext:Store>
            </Store>
            <BottomBar>
                <ext:Toolbar runat="server">
                    <Items>
                        <ext:Button ID="btnUCPlanAddInstr" runat="server" Text="Add Instrument" Icon="Add" Handler="App.direct.UCPLAN.OnSelectInstruments();">
                        <Listeners>
                            <AfterRender Handler="AriaPlanAddinstrButton(App.btnUCPlanAddInstr.getEl());" />
                        </Listeners>
                        </ext:Button>
                        <ext:Button ID="btnUCPlanDelInstr" runat="server" Text="Remove Instrument" Icon="Delete" Handler="App.direct.UCPLAN.OnRemoveInstrument();">
                            <Listeners>
                            <AfterRender Handler="AriaPlanDelInstrButton(App.btnUCPlanDelInstr.getEl());" />
                        </Listeners>
                        </ext:Button>
                    </Items>
                </ext:Toolbar>
            </BottomBar>
        </ext:GridPanel>

    </Items>
</ext:Panel>    
